/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.rcx.materialis.MaterialisResources;
import com.rcx.materialis.compat.TinkerToolRuneColor;
import com.rcx.materialis.datagen.MaterialisBlockStates;
import com.rcx.materialis.datagen.MaterialisBlockTags;
import com.rcx.materialis.datagen.MaterialisFluidSpills;
import com.rcx.materialis.datagen.MaterialisFluidTags;
import com.rcx.materialis.datagen.MaterialisItemModels;
import com.rcx.materialis.datagen.MaterialisItemTags;
import com.rcx.materialis.datagen.MaterialisLang;
import com.rcx.materialis.datagen.MaterialisLootTables;
import com.rcx.materialis.datagen.MaterialisMaterialTextures;
import com.rcx.materialis.datagen.MaterialisMaterials;
import com.rcx.materialis.datagen.MaterialisModifiers;
import com.rcx.materialis.datagen.MaterialisPartTextures;
import com.rcx.materialis.datagen.MaterialisRecipes;
import com.rcx.materialis.datagen.MaterialisRenderInfo;
import com.rcx.materialis.datagen.MaterialisToolDefinitions;
import com.rcx.materialis.datagen.MaterialisToolSlotLayouts;
import com.rcx.materialis.modifiers.OtherworldlyModifier;
import com.rcx.materialis.util.MaterialisPacketHandler;
import com.rcx.materialis.util.TinkerSpellWriteRecipe;
import com.rcx.materialis.util.TinkerToolFluxed;
import com.rcx.materialis.util.TintedModifierModel;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.model.tools.ToolModel;
import slimeknights.tconstruct.library.client.modifiers.ModifierModelManager;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerMaterialSpriteProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;

@Mod(value="materialis")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Materialis {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String modID = "materialis";

    public Materialis() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::doClientStuff);
        MaterialisResources.FLUIDS.register(bus);
        MaterialisResources.BLOCKS.register(bus);
        MaterialisResources.ITEMS.register(bus);
        MaterialisResources.ITEMS_EXTENDED.register(bus);
        MaterialisResources.RECIPE_SERIALIZERS.register(bus);
        MaterialisModifiers.MODIFIERS.register(bus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> MaterialisClient::onConstruct);
        if (ModList.get().isLoaded("ars_nouveau")) {
            ArsNouveauAPI.getInstance().getEnchantingRecipeTypes().add(TinkerSpellWriteRecipe.SPELL_WRITE_TYPE);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        MaterialisPacketHandler.init();
        if (ModList.get().isLoaded("quark")) {
            ToolCapabilityProvider.register(TinkerToolRuneColor::new);
        }
        ToolCapabilityProvider.register(TinkerToolFluxed::new);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        NBTKeyModel.registerExtraTexture((ResourceLocation)new ResourceLocation("tconstruct", "creative_slot"), (String)"sensor", (ResourceLocation)new ResourceLocation(modID, "item/sensor_slot"));
    }

    @SubscribeEvent
    public static void registerSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        ModifierManager.MODIFIER_LOADERS.register(new ResourceLocation(modID, "otherworldly"), OtherworldlyModifier.LOADER);
        if (ModList.get().isLoaded("ars_nouveau")) {
            Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)new ResourceLocation(modID, "tinker_spell_write"), TinkerSpellWriteRecipe.SPELL_WRITE_TYPE);
            event.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)TinkerSpellWriteRecipe.SERIALIZER.setRegistryName(new ResourceLocation(modID, "tinker_spell_write"))));
        }
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new MaterialisLang(gen));
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            MaterialisItemModels itemModels = new MaterialisItemModels(gen, existingFileHelper);
            gen.m_123914_((DataProvider)itemModels);
            gen.m_123914_((DataProvider)new MaterialisBlockStates(gen, existingFileHelper));
            MaterialisMaterialTextures materialSprites = new MaterialisMaterialTextures();
            MaterialisPartTextures partSprites = new MaterialisPartTextures();
            TinkerMaterialSpriteProvider tinkerMaterialSprites = new TinkerMaterialSpriteProvider();
            gen.m_123914_((DataProvider)new MaterialisRenderInfo(gen, materialSprites));
            gen.m_123914_((DataProvider)new GeneratorPartTextureJsonGenerator(gen, modID, (AbstractPartSpriteProvider)partSprites));
            gen.m_123914_((DataProvider)new MaterialPartTextureGenerator(gen, existingFileHelper, (AbstractPartSpriteProvider)new TinkerPartSpriteProvider(), new AbstractMaterialSpriteProvider[]{materialSprites}));
            gen.m_123914_((DataProvider)new MaterialPartTextureGenerator(gen, existingFileHelper, (AbstractPartSpriteProvider)partSprites, new AbstractMaterialSpriteProvider[]{materialSprites, tinkerMaterialSprites}));
        }
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new MaterialisLootTables(gen));
            gen.m_123914_((DataProvider)new MaterialisRecipes(gen));
            gen.m_123914_((DataProvider)new MaterialisModifiers(gen));
            gen.m_123914_((DataProvider)new MaterialisFluidSpills(gen));
            MaterialisBlockTags blockTags = new MaterialisBlockTags(gen, event.getExistingFileHelper());
            gen.m_123914_((DataProvider)blockTags);
            gen.m_123914_((DataProvider)new MaterialisItemTags(gen, blockTags, event.getExistingFileHelper()));
            gen.m_123914_((DataProvider)new MaterialisFluidTags(gen, event.getExistingFileHelper()));
            MaterialisMaterials materials = new MaterialisMaterials(gen);
            gen.m_123914_((DataProvider)materials);
            gen.m_123914_((DataProvider)new MaterialisMaterials.MaterialisMaterialStats(gen, materials));
            gen.m_123914_((DataProvider)new MaterialisMaterials.MaterialisMaterialTraits(gen, materials));
            gen.m_123914_((DataProvider)new MaterialisToolDefinitions(gen));
            gen.m_123914_((DataProvider)new MaterialisToolSlotLayouts(gen));
        }
    }

    @Mod.EventBusSubscriber(modid="materialis", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class MaterialisClient {
        public static void onConstruct() {
        }

        @SubscribeEvent
        static void itemColors(ColorHandlerEvent.Item event) {
            ItemColors colors = event.getItemColors();
            ToolModel.registerItemColors((ItemColors)colors, MaterialisResources.WRENCH);
            ToolModel.registerItemColors((ItemColors)colors, MaterialisResources.BATTLEWRENCH);
        }

        @SubscribeEvent
        static void registerModifierModels(ModifierModelManager.ModifierModelRegistrationEvent event) {
            event.registerModel(new ResourceLocation(Materialis.modID, "tinted"), TintedModifierModel.UNBAKED_INSTANCE);
        }
    }
}

